void init()
{
  frame.removeNotify();
  frame.setUndecorated(true);
  frame.addNotify();
  super.init();
}

// Ajastukseen muuttujia
int lastMillis = 0; // edellisen framen millis() arvo millisekunneissa
int deltaMillis = 0; // edellisen framen ja nykyisen framen millis() arvojen EROTUS millisekunneissa
float deltaSeconds = 0; // edellisen framen ja nykyisen frame arvojen EROTUS sekunneissa
int partMillis = 0; // ajettavan efektin millis() arvo (alkaa nollasta kun efekti vaihtuu)
int fullMillis = 0; // koko demon millis() arvo

boolean setupped[] = new boolean[100]; // Taulukko jossa pidetään kirjaa mille demon palaselle kutsuttu jo setup()
PFont debugFont = null; // Fontti debuggaustekstei varten

import ddf.minim.*;
Minim minim;
AudioPlayer bmusic;
float [] buffersizeL = new float[1024];
float [] buffersizeR = new float[1024];
float speed = 0.4;
float trans [] = new float [1024];

// Demon osioita (toteuttavat DemoPart interfacen)
Circles circles;
Starfield starfield;
TokaEfekti tokaEfekti;
FadeIn fadeIn;
FadeOut fadeOut;
Cube cube;


void setup() {
  // Laitoin nyt size():lle resoksi 1280x720 (HD ready) joka voisi olla hyvä reso jos pakottaa yhteen.
  // Toinen hyvä ois 1920x1080 (Full-HD) jos jaksaa pyörittää.
  //
  // Jos taas haluat tehdä resoluutioriippumatonta, niin laita tähän: displayWidth, displayHeight,
  // mutta muista sit kans testailla usealla.
  //
  // Starfield oli ainut efekti joka oli selkeästi tehty 800x600 resoluutioon. Se kantsii fiksaa!
  size(displayWidth, displayHeight, P3D);
  frameRate(30); // framerate 60 ois ideaali ja näyttäis sulavemmalta, mutta 
  lastMillis = millis();

  // Ladataan debugfontti (joudut generoimaan tän valikosta "Tools / Create Font..." tai vaihtamaan toiseksi)
  debugFont = loadFont("SansSerif-24.vlw");

  // Nollataan setupped taulukko
  for (int i=0; i<setupped.length; i++) setupped[i] = false;

  // Luodaan olio-instanssit demon osioista
  circles = new Circles();
  starfield = new Starfield();
  tokaEfekti = new TokaEfekti();
  fadeIn = new FadeIn();
  fadeOut = new FadeOut();
  cube = new Cube();
  smooth();
  minim = new Minim(this);
  bmusic = minim.loadFile("owlification.mp3", 1024);
  bmusic.play();
}


void draw() {
  // Lasketaan ajan kulkua
  int nowMillis = millis();
  deltaMillis = nowMillis - lastMillis;
  deltaSeconds = (float)deltaMillis / 1000.0f;


  int sceneNo = 0; // juokseva numero millä pidetään demon osasista kirjaa


  // tokaefekti
  if (fullMillis >= 0 && fullMillis < 19000) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      tokaEfekti.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    tokaEfekti.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // fade out tokaefekti
  if (fullMillis >= 16000 && fullMillis < 19000) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      fadeOut.setup(3000, 0, 0, 0); // fade length 3000 ms, color(0, 0, 0)
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    fadeOut.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // cube
  if (fullMillis > 19000 && fullMillis < 29500) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      cube.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    cube.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // fade in cube from black
  if (fullMillis >= 19000 && fullMillis < 21000) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      fadeIn.setup(2000, 0, 0, 0); // fade length 2000 ms, color(0, 0, 0)
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    fadeIn.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;


  // circles
  if (fullMillis >= 29500 && fullMillis < 42000) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      circles.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    circles.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // starfield
  if (fullMillis >= 42000 && fullMillis < 73000) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      starfield.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    starfield.draw(deltaSeconds, deltaMillis, partMillis, fullMillis); //(huomaa kuutio sen osana, se tulee tokaefektin jälkeen??)
  }
  sceneNo++;

  // starfield
  //if (fullMillis >= 50000 && fullMillis < 60000) {
  //  if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
     // starfield.setup();
     // partMillis = 0;
    //  setupped[sceneNo] = true;
   // }
  //  starfield.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
 // }
 // sceneNo++;

  // circles
  if (fullMillis >= 73000 && fullMillis < 95000) {
    if (setupped[sceneNo] == false) { // Tehdään-vain-kerran alustus tälle sektiolle
      circles.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    circles.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // täs vaiheessa demo loppuu
  if (fullMillis > 92000) {
    background(0, 0, 0);
    exit();
  }


  // Piirretään debug infoa (kommentoi lopullisessa veke!)
  hint(DISABLE_DEPTH_TEST);
  camera(); //reset camera
  perspective(); // reset perspective
  fill(255, 255, 255);
  textFont(debugFont);
 // text(round(frameRate)+" FPS", 25, 50);
  //text("partMillis = "+partMillis, 25, 80);
 // text("fullMillis = "+fullMillis, 25, 110);
  hint(ENABLE_DEPTH_TEST);


  // Lasketaan lisää ajan kulkua
  partMillis += deltaMillis;
  fullMillis += deltaMillis;
  lastMillis = nowMillis;
}


boolean sketchFullscreen() {
  return true;
}


